---
noteId: "m174phn5ee10y76bvzq3x5jnhh7yqjva"
title: "本でも書けるようにしたい"
tags: []
updatedAt: 1767674245031
docName: "notes:m174phn5ee10y76bvzq3x5jnhh7yqjva/content"
---

本のような巨大なサイズのドキュメントも、AI や他のユーザーと共同編集しながら書けるようにしたい。もちろん、スケールする方法で。

一番のボトルネックは、branch の作成だ。branch の作成時に doc 全体のメタデータをコピーする仕組みになっているけど、これがいくら小さくても、結局データサイズとか処理のボトルネックになっているように感じる。

本当に必要なのは、branch on write のような仕組みで、書き込んだブロックのデータだけがその瞬間にコピーされる仕組みだ。

また、触っていないページについては、そもそもデータの作成がされないような仕組みにしたい。

branch は今は多段階に作れるように設計しているが、これを無くしたらもっとシンプルにできるかも。 main branch と、そこから分岐した branch だけにする。そうしたら、block の情報のコピーも即座に行うことができるはずだ。

3-way merge を実現しようと思ったら、分岐点の状態が必要になる。分岐点に checkpoint がちゃんと作られていたら、その時点に巻き戻すことは今の設計とかわらないか。

どのレベルで copy on write するのか。ドキュメントレベルなのか、ページレベルなのか、Y.Doc (ブロックレベル) なのか。

そもそも何を copy するのか。データなのか、メタデータなのか。そもそも append 機構なので、データをコピーする必要はないはずだ。

Neon のデータ構造を参考にすべきかな。

シンプルに考えると、checkpoint での分岐時点での全ての block のメタデータを保持しておかないと、copy on write するときに分岐点の metadata に戻るには、データを巻き戻さないといけない

branch 側での変更と main 側での変更は混ざらない設計？それとも書き込み以外は混ざるってことなんだろうか。Neon では混ざらない。branch 間で共有している範囲が O(1) で分かれば、共有範囲の doc は main branch でも触らずに、コピーして編集するような仕組みになるということっぽい

確かに、例えば他の branch の分岐地点の updateId があれば、それより古い updateId を持つ doc に関しては、変更はせずにコピーするような仕組みにできる気がする。


一旦、copy on write の仕組みが作れたとしよう。そしたら何が起きるだろうか。

数百ページあるような巨大な本のようなドキュメントも、Codex を使って楽に編集させることができるようになる。気軽にbranchを作成できるので、どんな大きなドキュメントだって気軽に分岐して、編集して、レビューすることができる。レビューだって、必要なデータだけがコピーされるので、

